#ifndef __IMouseListener__
#define __IMouseListener__

#include "../Events/CMouseEvent.hpp"
using Exponent::GUI::Events::CMouseEvent;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Listeners
		{
			/**
			 * @interface IMouseListener IMouseListener.hpp
			 * @brief Allows for responding to mouse actions
			 *
			 * @date 21/08/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: IMouseListener.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			interface IMouseListener
			{

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 */
				IMouseListener() { }
				
				/**
				 * Destruction
				 */
				virtual ~IMouseListener() { }

//	===========================================================================

				/**
				 * Handle left button being clicked
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonDown(CMouseEvent &event) = 0;

				/**
				 * Handle left button being released
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonUp(CMouseEvent &event) = 0;

				/**
				 * Handle the right button being clicked
				 * @param event The event to handle
				 */
				virtual void handleRightButtonDown(CMouseEvent &event) = 0;

				/**
				 * Handle the right button being released
				 * @param event The event to handle
				 */
				virtual void handleRightButtonUp(CMouseEvent &event) = 0;

				/**
				 * Handle a double click on the left button
				 * @param event The event to handle
				 */
				virtual void handleDoubleClick(CMouseEvent &event) = 0;

				/**
				 * Handle the scroll wheel
				 * @param event The event to handle
				 */
				virtual void handleMouseScroll(CMouseEvent &event) = 0;

				/**
				 * Handle the mouse movement
				 * @param event The event to handle
				 */
				virtual void handleMouseMovement(CMouseEvent &event) = 0;

				/**
				 * Handle a mouse leaving the root area
				 * @param event The event to handle
				 */
				virtual void handleMouseLeavingArea(CMouseEvent &event) = 0;

//	===========================================================================
			};
		}
	}
}
#endif	// End of IMouseListener.hpp